

#ifndef _PROV_SERVER_
#define _PROV_SERVER_

#include "stdafx.h"
#include <stdio.h>
#include <stdlib.h>
#include <winsock2.h>
#include <ws2tcpip.h>
#include <windows.h>		//must be included after winsock2.h to avoid redefinition
#include <tbs.h>
#include <assert.h>

//#include <WinSock2.h>
//#include "TtvApi.h"
#include <iostream>

using namespace std;

#define DEFAULT_TPM_PORT 2321
#define DEFAULT_PLATFORM_PORT  DEFAULT_TPM_PORT+1
#define MAX_BUFFER_LEN 1048576

#define MAX_BUFFER_SIZE 1024

typedef UINT32 TPM_RC;
#define    TPM_RC_SUCCESS              (TPM_RC)(0x000)    


//
// byte swap macros
//
#define BSWAP16(x)              ((((x) & 0xff) << 8)  | ((x) >> 8))

#define BSWAP32(x)              ((((x) & 0xff) << 24) | (((x) & 0xff00) << 8) | \
	(((x)& 0xff0000) >> 8) | (((x)& 0xff000000) >> 24))



//
// TPM20 Packet headers
//
#pragma pack (push, 1) 


//
// Generic headers
// 
typedef struct _TPM20_Header_In {
	UINT16 tag;
	UINT32 command_size;
	UINT32 command_code;
} TPM20_Header_In;

typedef struct _TPM20_Header_Out {
	UINT16 tag;
	UINT32 response_size;
	UINT32 response_code;
} TPM20_Header_Out;




#pragma pack(pop)


class TtvServer {
private:
	//The input and output data buffers for the simulator.
	char *mRecvBuf;
    int  mRecvBufLen;

	SOCKET mTpmSocket;
	SOCKET mPlatformSocket;

	//
	// Global TBS TPM Context Handle
	//
	TBS_HCONTEXT g_tbs_handle;

	UINT8 g_tpm_in_buffer[MAX_BUFFER_SIZE];
	UINT8 g_tpm_out_buffer[MAX_BUFFER_SIZE];

	

	//
	// TBS Version 2

	TBS_CONTEXT_PARAMS2 tpm_context_params;
	TBS_RESULT tbs_ret_val;

public:
	TtvServer();
	~TtvServer();

	int readBytes(SOCKET s, char* buffer, int NumBytes);
	int writeBytes(SOCKET s, char* buffer, int NumBytes);

	int createListenSocket(int portnumber, SOCKET *listensocket);

	int processTpmCommand();
	int processPlatformCommand();

	static DWORD WINAPI startPlatformThread(LPVOID lpParam); // need dword for CreateThread()

	DWORD startPlatformService(); 
	int startTpmService();
	int start();
};

#endif // ifndef _PROV_SERVER_